<?php
echo '
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>کیس و دوستیابی</title>
<style>
@import url("https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;700&display=swap");

* { margin:0; padding:0; box-sizing:border-box; }

body {
    font-family: "Vazirmatn", sans-serif;
    background: linear-gradient(135deg, #00bfa5, #1de9b6);
    min-height: 100vh;
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 50px 20px;
    overflow-y: auto;
}

/* کارت پروفایل */
.profile-card {
    background: rgba(255,255,255,0.25);
    backdrop-filter: blur(12px);
    border-radius: 20px;
    width: 260px;
    margin: 15px 0;
    padding: 20px;
    text-align: center;
    box-shadow: 0 8px 20px rgba(0,0,0,0.2);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.profile-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 12px 25px rgba(0,0,0,0.3);
}

.profile-card img {
    width: 90px;
    height: 90px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid #00bfa5;
    margin-bottom: 10px;
}

.profile-card .name {
    font-size: 20px;
    font-weight: bold;
    margin-bottom: 5px;
    color: #fff;
}

.profile-card .status, .profile-card .bio {
    font-size: 14px;
    margin: 3px 0;
    color: #f0f0f0;
}

.profile-card .status span {
    color: #a5ffeb;
}

/* دکمه دریافت ایدی */
.profile-card button {
    margin-top: 15px;
    width: 100%;
    padding: 12px;
    font-size: 16px;
    font-weight: bold;
    border: none;
    border-radius: 50px;
    background: linear-gradient(135deg, #007bff, #00bfa5);
    color: white;
    cursor: pointer;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.profile-card button:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 15px rgba(0,123,255,0.3);
}

/* پاپ‌آپ */
.overlay {
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: rgba(0,0,0,0.5);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 1000;
}

.modal {
    background: rgba(255,255,255,0.25);
    backdrop-filter: blur(15px);
    border-radius: 20px;
    padding: 25px 20px;
    width: 320px;
    text-align: center;
    color: #fff;
    opacity: 0;
    transform: scale(0.8);
    transition: all 0.3s ease;
}

.modal.active {
    opacity: 1;
    transform: scale(1);
}

.modal p {
    margin: 15px 0;
    font-size: 16px;
}

.modal button {
    margin-top: 10px;
    padding: 12px 28px;
    border: none;
    border-radius: 50px;
    font-size: 16px;
    font-weight: bold;
    cursor: pointer;
    background: linear-gradient(135deg, #007bff, #00bfa5);
    color: white;
    transition: all 0.3s ease;
}

.modal button:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 15px rgba(0,123,255,0.3);
}
</style>
</head>
<body>

<div class="profile-card">
    <img src="1.png" alt="Profile Image">
    <div class="name">هانیه</div>
    <div class="status">وضعیت تفعل: مجرد</div>
    <div class="status">وضعیت آنلاین: <span>آنلاین</span></div>
    <div class="bio">بیوگرافی: یه پسر خوشتیپ بیاد فقط</div>
    <button onclick="showModal()">دریافت ایدی</button>
</div>

<div class="profile-card">
    <img src="2.png" alt="Profile Image">
    <div class="name">پانیذ</div>
    <div class="status">وضعیت تفعل: متاهل</div>
    <div class="status">وضعیت آنلاین: <span>آخرین بازدید 1 دقیقه پیش</span></div>
    <div class="bio">بیوگرافی: همیشه آنلاینم یه پسر مودب پیوی باشه</div>
    <button onclick="showModal()">دریافت ایدی</button>
</div>

<div class="profile-card">
    <img src="3.png" alt="Profile Image">
    <div class="name">الناز</div>
    <div class="status">وضعیت تفعل: مجرد</div>
    <div class="status">وضعیت آنلاین: <span>آنلاین</span></div>
    <div class="bio">بیوگرافی: اگر تو وجودت مردی حس کردی می‌تونی پیام بدی</div>
    <button onclick="showModal()">دریافت ایدی</button>
</div>

<div class="overlay" id="overlay">
    <div class="modal" id="modal">
        <p>شما حسابی ندارید. برای دریافت ایدی لطفاً ثبت نام کنید.</p>
        <button onclick="window.location.href=\'sabtnam\'">ثبت نام</button>
    </div>
</div>

<script>
function showModal() {
    const overlay = document.getElementById("overlay");
    const modal = document.getElementById("modal");
    overlay.style.display = "flex";
    setTimeout(() => {
        modal.classList.add("active");
    }, 10);
}

document.getElementById("overlay").addEventListener("click", function(e){
    if(e.target === this){
        const modal = document.getElementById("modal");
        modal.classList.remove("active");
        setTimeout(() => { this.style.display = "none"; }, 300);
    }
});
</script>

</body>
</html>
';
?>
