<?php

// ==============================
// BOT TOKEN
// ==============================
$botToken = "7911347868:AAEn7lyKe2p6-51ud-DcDz9riafvgsxgdKk"; // جایگزین توکن واقعی
$apiURL = "https://api.telegram.org/bot$botToken/";

// ==============================
// STATE SYSTEM
// ==============================
function loadState() {
    return file_exists("state.json") ? json_decode(file_get_contents("state.json"), true) : [];
}

function saveState($state) {
    file_put_contents("state.json", json_encode($state));
}

$state = loadState();

// ==============================
// SEND MESSAGE
// ==============================
function sendMessage($chatId, $text, $keyboard = null) {
    global $apiURL;
    $data = [
        "chat_id" => $chatId,
        "text" => $text,
        "parse_mode" => "HTML"
    ];
    if ($keyboard)
        $data["reply_markup"] = json_encode($keyboard);
    file_get_contents($apiURL . "sendMessage?" . http_build_query($data));
}

// ==============================
// ANSWER CALLBACK QUERY
// ==============================
function answerCallback($callback_id, $text = "در حال پردازش...") {
    global $apiURL;
    file_get_contents($apiURL . "answerCallbackQuery?" . http_build_query([
        "callback_query_id" => $callback_id,
        "text" => $text,
        "show_alert" => false
    ]));
}

// ==============================
// GENERATE UUID
// ==============================
function generateUUID() {
    return sprintf(
        '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        mt_rand(0, 0xffff), mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0x0fff) | 0x4000,
        mt_rand(0, 0x3fff) | 0x8000,
        mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
    );
}

// ==============================
// BUILD VLESS TCP+TLS
// ==============================
function buildVless($uuid, $server, $port, $sni) {
    return "vless://$uuid@$server:$port?type=tcp&security=tls&sni=$sni&alpn=h2#Telegram";
}

// ==============================
// READ UPDATE
// ==============================
$update = json_decode(file_get_contents("php://input"), true);
$chatId = $update["message"]["chat"]["id"] ?? null;
$text   = $update["message"]["text"] ?? null;
$data   = $update["callback_query"]["data"] ?? null;
$callback_id = $update["callback_query"]["id"] ?? null;

if (!isset($state[$chatId])) $state[$chatId] = ["step" => "none"];

// ==============================
// START BOT
// ==============================
if (isset($text) && $text == "/start") {
    $keyboard = [
        "inline_keyboard" => [
            [
                ["text" => "ساخت کانفیگ", "callback_data" => "makecfg"]
            ]
        ]
    ];
    sendMessage($chatId, "سلام! برای ساخت کانفیگ دکمه زیر را بزن:", $keyboard);
    exit;
}

// ==============================
// CALLBACK QUERY HANDLER
// ==============================
if (isset($data)) {

    answerCallback($callback_id); // پاسخ به callback query

    if ($data == "makecfg") {
        $state[$chatId]["step"] = "ask_panel_url";
        saveState($state);
        sendMessage($chatId, "لینک پنل خود را بفرست (مثال: http://IP:PORT/RANDOM_PATH):");
        exit;
    }
}

// ==============================
// STEPS FOR CONFIG CREATION
// ==============================
if ($state[$chatId]["step"] == "ask_panel_url" && isset($text)) {
    $state[$chatId]["panel"] = $text;
    $state[$chatId]["step"] = "ask_server";
    saveState($state);
    sendMessage($chatId, "آی‌پی یا دامنه سرور را بفرست:");
    exit;
}

if ($state[$chatId]["step"] == "ask_server" && isset($text)) {
    $state[$chatId]["server"] = $text;
    $state[$chatId]["step"] = "ask_port";
    saveState($state);
    sendMessage($chatId, "پورت سرور:");
    exit;
}

if ($state[$chatId]["step"] == "ask_port" && isset($text)) {
    $state[$chatId]["port"] = $text;
    $state[$chatId]["step"] = "ask_sni";
    saveState($state);
    sendMessage($chatId, "دامنه SNI برای TLS:");
    exit;
}

if ($state[$chatId]["step"] == "ask_sni" && isset($text)) {
    $state[$chatId]["sni"] = $text;
    $state[$chatId]["step"] = "ask_gb";
    saveState($state);
    sendMessage($chatId, "حجم کانفیگ به گیگ:");
    exit;
}

if ($state[$chatId]["step"] == "ask_gb" && isset($text)) {
    $state[$chatId]["gb"] = $text;
    $state[$chatId]["step"] = "ask_days";
    saveState($state);
    sendMessage($chatId, "مدت اعتبار (روز):");
    exit;
}

if ($state[$chatId]["step"] == "ask_days" && isset($text)) {
    $state[$chatId]["days"] = $text;
    $state[$chatId]["step"] = "ask_users";
    saveState($state);
    sendMessage($chatId, "تعداد کاربر (۰ برای بینهایت):");
    exit;
}

if ($state[$chatId]["step"] == "ask_users" && isset($text)) {
    $state[$chatId]["users"] = $text;

    // ساخت UUID و کانفیگ
    $uuid = generateUUID();
    $cfg  = buildVless(
        $uuid,
        $state[$chatId]["server"],
        $state[$chatId]["port"],
        $state[$chatId]["sni"]
    );

    sendMessage($chatId, "✅ کانفیگ ساخته شد:\n\n<code>$cfg</code>");

    $state[$chatId]["step"] = "done";
    saveState($state);
    exit;
}

?>
